/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.model.cuboid;

import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.cache.model.GeoQuad;
import software.bernie.geckolib.util.RenderUtil;

public record GeoCube(@Nullable GeoQuad[] quads, class_243 pivot, class_243 rotation, class_243 size) {
    public void render(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, int renderColor) {
        this.translateToPivotPoint(poseStack);
        this.rotate(poseStack);
        this.translateAwayFromPivotPoint(poseStack);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : this.quads) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(quad.normalVec());
            RenderUtil.fixInvertedFlatCube(this, normal);
            quad.render(poseState, normal, vertexConsumer, packedLight, packedOverlay, renderColor);
        }
    }

    public void rotate(class_4587 poseStack) {
        class_243 rotation = this.rotation();
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.method_10215()));
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)rotation.method_10214(), 0.0f));
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ((float)rotation.method_10216(), 0.0f, 0.0f));
    }

    public void translateToPivotPoint(class_4587 poseStack) {
        poseStack.method_22904(this.pivot().method_10216() / 16.0, this.pivot().method_10214() / 16.0, this.pivot().method_10215() / 16.0);
    }

    public void translateAwayFromPivotPoint(class_4587 poseStack) {
        poseStack.method_22904(-this.pivot().method_10216() / 16.0, -this.pivot().method_10214() / 16.0, -this.pivot().method_10215() / 16.0);
    }
}

